/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.data.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.incubation.core.registry.IncubationBlocks;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class IncubationLootTableProvider
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(BlockProvider::new, (Object)LootContextParamSets.f_81421_));

    public IncubationLootTableProvider(DataGenerator generator) {
        super(generator);
    }

    public List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.tables;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
    }

    private static class BlockProvider
    extends BlockLoot {
        private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS));

        private BlockProvider() {
        }

        public void addTables() {
            this.m_124288_((Block)IncubationBlocks.CHICKEN_EGG_CRATE.get());
            this.m_124288_((Block)IncubationBlocks.TURTLE_EGG_CRATE.get());
            this.m_124288_((Block)IncubationBlocks.HAY_NEST.get());
            this.m_124147_((Block)IncubationBlocks.HAY_CHICKEN_NEST.get(), (ItemLike)IncubationBlocks.HAY_NEST.get());
            this.m_124147_((Block)IncubationBlocks.HAY_DUCK_NEST.get(), (ItemLike)IncubationBlocks.HAY_NEST.get());
            this.m_124147_((Block)IncubationBlocks.HAY_TURKEY_NEST.get(), (ItemLike)IncubationBlocks.HAY_NEST.get());
            this.m_124175_((Block)IncubationBlocks.TWIG_NEST.get(), BlockProvider::createTwigNestDrops);
            this.m_124175_((Block)IncubationBlocks.TWIG_CHICKEN_NEST.get(), BlockProvider::createTwigNestDrops);
            this.m_124175_((Block)IncubationBlocks.TWIG_DUCK_NEST.get(), BlockProvider::createTwigNestDrops);
            this.m_124175_((Block)IncubationBlocks.TWIG_TURKEY_NEST.get(), BlockProvider::createTwigNestDrops);
        }

        protected static LootTable.Builder createShearsDispatchTable(Block block, LootPoolEntryContainer.Builder<?> builder) {
            return BlockProvider.m_124171_((Block)block, (LootItemCondition.Builder)HAS_SHEARS, builder);
        }

        protected static LootTable.Builder createTwigNestDrops(Block block) {
            return BlockProvider.createShearsDispatchTable((Block)IncubationBlocks.TWIG_NEST.get(), (LootPoolEntryContainer.Builder)BlockProvider.m_236221_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))));
        }

        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block) != null && "incubation".equals(ForgeRegistries.BLOCKS.getKey(block).m_135827_())).collect(Collectors.toSet());
        }
    }
}

